<!DOCTYPE html>
<html lang="fa">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ایجاد کد تخفیف</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f7fa;
            margin: 0;
            padding: 20px;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
        }
        .container {
            background-color: #fff;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            border-radius: 10px;
            padding: 30px;
            width: 400px;
            text-align: center;
        }
        .title {
            font-size: 22px;
            margin-bottom: 20px;
            color: #333;
        }
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
        }
        input[type="number"], input[type="text"], input[type="date"], select {
            width: 100%;
            padding: 10px;
            margin-bottom: 20px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 14px;
        }
        input[type="submit"], .copy-btn {
            background-color: #28a745;
            color: white;
            padding: 10px 20px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            margin-top: 10px;
        }
        .code-result {
            background-color: #f8f9fa;
            padding: 10px;
            border: 1px dashed #28a745;
            margin-top: 20px;
            color: #28a745;
            font-weight: bold;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .copy-btn {
            background-color: #007bff;
            margin-right: 10px;
        }
        .footer b {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="title">ایجاد کد تخفیف</div>
        <form method="POST" action="">
            <label for="type">نوع تخفیف:</label>
            <select name="type" id="type">
                <option value="percent">درصدی</option>
                <option value="fixed">مبلغ ثابت</option>
            </select>
            <label for="amount">مقدار تخفیف:</label>
            <input type="number" name="amount" id="amount" required placeholder="مقدار تخفیف را وارد کنید">
            <label for="usage">تعداد استفاده:</label>
            <input type="number" name="usage" id="usage" required placeholder="تعداد دفعات استفاده را وارد کنید">
            <label for="expiry_date">تاریخ انقضا:</label>
            <input type="date" name="expiry_date" id="expiry_date" required>
            <input type="submit" name="generate" value="ایجاد کد">
        </form>
        <?php
        if (isset($_POST['generate'])) 
        {
            require_once __DIR__ . '/../config.php';
            require_once __DIR__ . '/../functions/main.php';
            $type        = $_POST['type'];
            $amount      = $_POST['amount'];
            $expiry_date = $_POST['expiry_date'] . ' 23:59:59';
            $usage       = $_POST['usage'];
            $code        = random(15);
            $timestamp   = strtotime($expiry_date);
            echo "<div class='code-result'>
                    <span id='coupon-code'>$code</span>
                    <button class='copy-btn' onclick='copyCode()'>کپی کد</button>
                  </div>";
            $db->query("INSERT INTO `copon` (`type`, `amount`, `code`, `usage`, `expiry_date`) VALUES ('$type', '$amount', '$code', '$usage', '$timestamp')");
        }
        ?>
        <div class="footer"><b>Code By : @SeniorMehdy</b></div>
    </div>
    <script>
        function copyCode() {
            var codeText = document.getElementById("coupon-code").innerText;
            var tempInput = document.createElement("input");
            tempInput.value = codeText;
            document.body.appendChild(tempInput);
            tempInput.select();
            document.execCommand("copy");
            document.body.removeChild(tempInput);
            alert("کد تخفیف کپی شد: " + codeText);
        }
    </script>
</body>
</html>