<?php
ob_start();
# ========= include (اول برای خطاها) =========== #
require_once 'config.php';
require_once 'functions/main.php';
require_once 'text/main.php';
/* =========================== 
نویسنده :
@SeniorMehdy
کانال :
@MahdyBots
در صورت بروز هر گونه مشکل ب پیوی نویسنده سورس مراجعه کنید

تحت هیچ شرایطی متن را حذف یا ویرایش نکنید
=========================== */
# ========= دریافت Update =========== #
$rawInput = file_get_contents('php://input');
if (empty($rawInput)) {
    http_response_code(200);
    exit;
}
$update = json_decode($rawInput);
if (!$update || !isset($update->update_id)) {
    http_response_code(200);
    exit;
}
# ========= Anti Fake Update (پشتیبانی از Proxy/Cloudflare) =========== #
$client_ip = $_SERVER['REMOTE_ADDR'] ?? '';
if (!empty($_SERVER['HTTP_CF_CONNECTING_IP'])) $client_ip = $_SERVER['HTTP_CF_CONNECTING_IP'];
elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) $client_ip = trim(explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0]);
elseif (!empty($_SERVER['HTTP_X_REAL_IP'])) $client_ip = $_SERVER['HTTP_X_REAL_IP'];
$telegram_ip_ranges = [['lower' => '149.154.160.0', 'upper' => '149.154.175.255'], ['lower' => '91.108.4.0', 'upper' => '91.108.7.255']];
$ok = false;
if (!empty($client_ip) && filter_var($client_ip, FILTER_VALIDATE_IP)) {
    $ip_dec = (float)sprintf("%u", ip2long($client_ip));
    foreach ($telegram_ip_ranges as $telegram_ip_range) {
        $lower_dec = (float)sprintf("%u", ip2long($telegram_ip_range['lower']));
        $upper_dec = (float)sprintf("%u", ip2long($telegram_ip_range['upper']));
        if ($ip_dec >= $lower_dec && $ip_dec <= $upper_dec) { $ok = true; break; }
    }
}
if (!$ok) {
    http_response_code(403);
    exit('Are You Lost ? (@Code By : @SeniorMehdy)');
}
# ========= استخراج امن متغیرها از Update =========== #
$message = $update->message ?? $update->edited_message ?? null;
$callback = $update->callback_query ?? null;
$channel_post = $update->channel_post ?? null;
if (!$message && !$callback) {
    http_response_code(200);
    exit;
}
$from_id = $message->from->id ?? $callback->from->id ?? $channel_post->chat->id ?? null;
$chat_id = $message->chat->id ?? $callback->message->chat->id ?? $channel_post->chat->id ?? null;
$text = $message->text ?? $channel_post->text ?? $callback->data ?? null;
$type = $message->chat->type ?? $callback->message->chat->type ?? $channel_post->chat->type ?? null;
$message_id = $message->message_id ?? $callback->message->message_id ?? $channel_post->message_id ?? null;
$data = $callback->data ?? null;
$callback_query_id = $callback->id ?? null;
if (!$from_id || !$chat_id) {
    http_response_code(200);
    exit;
}
$text = $text ?? '';
# ========= DB Data =========== #
$user_sql    = $db->query("SELECT * FROM `user` WHERE `from_id` = '$from_id'");
$user        = mysqli_fetch_assoc($user_sql) ?: [];
$step        = $user['step'] ?? '0';
$admin_sql   = $db->query("SELECT `type_id`,`columnOne` FROM `settings` WHERE `type` = 'admin' AND `type_id` = '$from_id'");
$admins_sql  = $db->query("SELECT `type_id`,`columnOne` FROM `settings` WHERE `type` = 'admin'");
$block       = $db->query("SELECT * FROM `block` WHERE `user_id` = '$from_id'");
# ========= Keyboards =========== #
if (mysqli_num_rows($admin_sql) > 0) 
{
    $btn_home = json_encode(['keyboard' => [[['text' => '🛍 خرید فیلترشکن']],[['text' => '✨ قرعه کشی'],['text' => '💰 کیف پول من']],[['text' => '💸 همکاری و کسب درآمد'],['text' => '💡 تست رایگان فیلترشکن']],[['text' => '☎️ راهنما و پشتیبانی']],[['text' => '👤 مدیریت']]],'input_field_placeholder' => '🏠  منوی اصلی ادمین', 'resize_keyboard' => true]);
    $panel    = json_encode(['keyboard' => [[['text' => '🪄 بخش قرعه کشی'],['text' => '🕹 مدیریت دکمه ها']],[['text' => '💳 مدیریت کارت ها'],['text' => '📡 مدیریت سرور ها']],[['text' => '💰 گزارش مالی'],['text' => '👤 امار ربات']],[['text' => '⚙️ تنظیمات'], ['text' => '👥 مدیریت ممبر ها']],[['text' => '📫 بخش ارسال پیام'],['text' => '📝 بخش متن ها']],[['text' => '🔒 بخش قفل ها'], ['text' => '🧑🏻‍💻 بخش ادمین ها']],[['text' => '🎁 کد تخفیف'],['text' => '➕ افزودن کانفیگ']],[['text' => '🔙']]],'input_field_placeholder' => '👨‍💻 پنل ادمین', 'resize_keyboard' => true]);
    $btn_back = json_encode(['keyboard' => [[['text' => '🔙 بازگشت']]], 'resize_keyboard' => true]);
}
elseif (isset($user['type']) && $user['type'] === 'vipuser') $btn_home = json_encode(['keyboard' => [[['text' => '🛍 خرید فیلترشکن']],[['text' => '✨ قرعه کشی'],['text' => '💰 کیف پول من']],[['text' => '💸 همکاری و کسب درآمد'],['text' => '💡 تست رایگان فیلترشکن']],[['text' => '💎 ورود به بخش vip'],['text' => '☎️ راهنما و پشتیبانی']]],'input_field_placeholder' => '🏠  منوی اصلی', 'resize_keyboard' => true]);
else $btn_home = json_encode(['keyboard' => [[['text' => '🛍 خرید فیلترشکن']],[['text' => '✨ قرعه کشی'],['text' => '💰 کیف پول من']],[['text' => '💸 همکاری و کسب درآمد'],['text' => '💡 تست رایگان فیلترشکن']],[['text' => '☎️ راهنما و پشتیبانی']]],'input_field_placeholder' => '🏠  منوی اصلی ادمین', 'resize_keyboard' => true]);
$back_btn  = json_encode(['keyboard' => [[['text' => '🔙']]], 'resize_keyboard' => true]);
$remove    = json_encode(['remove_keyboard' => [], 'remove_keyboard' => true]);
# ========= Checkers =========== #
if (mysqli_num_rows($user_sql) === 0 & $type === 'private') $db->query("INSERT INTO `user`(`from_id`, `step`, `started`) VALUES ('$from_id', '0', '$date')");
$db->query("UPDATE `user` SET `update_at` = '$time' WHERE `from_id` = '$from_id'");
if (file_exists('OFF') and (!mysqli_num_rows($admin_sql) > 0))
{
    sendMessage($from_id, 'ربات برای ارتقا، آپدیت، رفع مشکلات و بروز رسانی خاموش میباشد ❗️', 'markdown', $remove, $message_id);
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    mysqli_close($db);
    exit(false);
}
if (mysqli_num_rows($block) > 0) exit(false);
if (isset($data))
{
    require_once 'data.php';
    mysqli_close($db);
    exit(false);
}
$invalidChars = ['}', '[', '{', "'", ';', '*'];
if (strpbrk($text, implode('', $invalidChars)) !== false) 
{
    sendMessage($from_id, 'از ارسال کاراکتر غیرمجاز خودداری کنید ❗️⚠️', 'markdown', $btn_home, $message_id);
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    mysqli_close($db);
    exit(false);
}
if (!mysqli_num_rows($admin_sql) > 0) Spam($from_id);
if (preg_match('/^\/lock_(.*)/', $text, $match))
{
    $gap_id = $message->chat->id ?? $callback->message->chat->id ?? null;
    $channel_id = $channel_post->chat->id ?? null;
    $channel_message_id = $channel_post->message_id ?? null;
    $random = $match[1];
    if ($type === 'channel')
    {
        $lock_id = $channel_id;
        $lock_message_id = $channel_message_id;
    }
    elseif ($type === 'group' or $type === 'supergroup')
    {
        $lock_id = $gap_id;
        $lock_message_id = $message_id;
    }
    $new_lock_sql = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` = 'false'"));
    if ($random === $new_lock_sql['columnOne'])
    {
        if ($type === 'channel' or $type === 'group' or $type === 'supergroup')
        {
            if (mysqli_num_rows($db->query("SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` = '$lock_id'")) == 0)
            {
                $db->query("UPDATE `settings` SET `type_id`='$lock_id' WHERE `type` = 'lock' AND `type_id` = 'false' AND `columnOne` = '$random'");
                $lock_data = getChat($lock_id)->result;
                $lock_title = $lock_data->title;
                $lock_username = $lock_data->username ? : 'ندارد';
                $lock_link = $lock_data->invite_link;
                sendMessage(LOG, "✅ قفل با موفقیت اضافه شد. \n\n📑 مشخصات:\n❔ نوع قفل : {$type}\n✏️ نام : {$lock_title}\n👤 نام کاربری : {@$lock_username}\n🔗 لینک : {$lock_link}\n🆔 ایدی عددی قفل : {$lock_id}");
                deleteMessage($lock_id, $lock_message_id);
            }
        } else sendMessage($from_id, '❌ این دستور تنها در کانال یا گروه امکان پذیر است');
    }
}
/* =========================== 
نویسنده :
@SeniorMehdy
کانال :
@MahdyBots
در صورت بروز هر گونه مشکل ب پیوی نویسنده سورس مراجعه کنید

تحت هیچ شرایطی متن را حذف یا ویرایش نکنید
=========================== */
elseif (($text === '/start' or $text === '🔙') and $type === 'private')
{
    $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
    sendMessage($from_id, $botText['start'], 'HTML', $btn_home, $message_id);
    $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'free'"));
    if (!isset($step) and $botSettings['type_id'] === 'on')
    {
        sendMessage($from_id, "💥 کاربر گرامی {$botSettings['columnOne']} تومن هدیه برای تست رایگان محصولات ما به حساب شما افزوده شد \n\n🍺 برای تست سرویس وارد بخش خرید فیلترشکن بشید سپس روی دکمه فیلترشکن حرفه ای بزنید و گزینه اول یعنی تست سرویس رو انتخاب کنید\n\n✅ همچنین شما میتوانید بجای تست سرویس مستقیم از این موجودی برای خرید از قسمت اصلی استفاده کنید");
        $db->query("UPDATE `user` SET `balance` = '{$botSettings['columnOne']}' WHERE `from_id` = '$from_id'");
    }
    $db->query("UPDATE `user` SET `step` = 'none', `code` = NULL WHERE `from_id` = '$from_id'");
    mysqli_close($db);
    exit(false);
}
elseif (preg_match('/^(\/start) (.*)/', $text, $match) and $type === 'private')
{
    if (!is_numeric($match[2]) or $match[2] < 1) exit(false);
    $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
    if (isset($step))
    {
        sendMessage($from_id, $botText['start'], 'HTML', $btn_home, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'free'"));
    if ($botSettings['type_id'] === 'on')
    {
        sendMessage($from_id, "💥 کاربر گرامی {$botSettings['columnOne']} تومن هدیه برای تست رایگان محصولات ما به حساب شما افزوده شد \n\n🍺 برای تست سرویس وارد بخش خرید فیلترشکن بشید سپس روی دکمه فیلترشکن حرفه ای بزنید و گزینه اول یعنی تست سرویس رو انتخاب کنید\n\n✅ همچنین شما میتوانید بجای تست سرویس مستقیم از این موجودی برای خرید از قسمت اصلی استفاده کنید");
        $db->query("UPDATE `user` SET `balance` = '{$botSettings['columnOne']}' WHERE `from_id` = '$from_id'");
    }
    if (isJoin($from_id))
    {
        $btn_home = json_encode(['keyboard' => [[['text'=>'✅ تایید شماره','request_contact' => true]],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, $botText['start'],'HTML', $btn_home, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none', `isInvited` = 1, `adder` = '{$match[2]}' WHERE `from_id` = '$from_id'");
        newMember($from_id, $user['adder']);
    } 
    else
    {
        joinSend($from_id);
        $db->query("UPDATE `user` SET `step` = 'Invited', `isInvited` = 1, `adder` = '{$match[2]}' WHERE `from_id` = '$from_id'");
    }
    mysqli_close($db);
    exit(false);
}
elseif ($text === '🛍 خرید فیلترشکن' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $btnVpnType  = json_encode(['keyboard' => [[['text' => '✅ فیلترشکن عادی']],[['text' => '🧨 فیلترشکن حرفه ای']],[['text' => '🔥 سرویس حجم نامحدود']],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, $botText['service'], 'HTML', $btnVpnType);
        $db->query("UPDATE `user` SET `step` = 'selectServer' WHERE `from_id` = '$from_id'");
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif (($text === '✨ قرعه کشی' or $text === '✨ شرکت قرعه کشی') and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $btnLottery = json_encode(['inline_keyboard' => [[['text' => '✅ شرکت در قرعه کشی جدید', 'callback_data' => 'joinLottery']],[['text' => '❌ بازگشت به منوی قبل', 'callback_data' => 'start']]]]);
        sendMessage($from_id, $botText['Lottery'], 'HTML', $btnLottery);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '💸 همکاری و کسب درآمد' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $btnSelling = json_encode(['inline_keyboard' => [[['text' => '🧾 تعرفه های همکاری در فروش', 'callback_data' => 'listSelling']],[['text' => '✅ شروع همکاری', 'callback_data' => 'startSelling']],[['text' => '❌ بازگشت به منوی قبل', 'callback_data' => 'start']]]]);
        sendMessage($from_id, $botText['selling'], 'HTML', $btnSelling, $message_id);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '💡 تست رایگان فیلترشکن' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $btnTest= json_encode(['keyboard' => [[['text' => '🦊 تست سرویس Fox']],[['text' => '👥 زیرمجموعه گیری'],['text' => '🪄 امتیاز روزانه']],[['text' => '❤️ ری اکشن زدن'],['text' => '📢 عضویت در کانال ها']],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, $botText['test'], 'HTML', $btnTest, $message_id);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '🦊 تست سرویس Fox' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botText = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $btnVpnType  = json_encode(['keyboard' => [[['text' => '✅ فیلترشکن عادی']],[['text' => '🧨 فیلترشکن حرفه ای']],[['text' => '🔥 سرویس حجم نامحدود']],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, $botText['service'], 'HTML', $btnVpnType);
        $db->query("UPDATE `user` SET `step` = 'selectTestingServer' WHERE `from_id` = '$from_id'");
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '☎️ راهنما و پشتیبانی' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $first_name  = htmlspecialchars($message->from->first_name ?? '');
        $btnSupp= json_encode(['inline_keyboard' => [[['text' => '❔سوالات متداول', 'callback_data' => 'faq']],[['text' => '❌ بازگشت به منوی اصلی', 'callback_data' => 'start']]]]);
        sendMessage($from_id, "کاربرگرامی، $first_name عزیز برای سریع تر شدن روند پاسخگویی ما لیستی از سوالات متداول رو برای شما آماده کردیم ابتدا این بخش رو مطالعه کنید و اگر جواب مشکل شما در ان نبود به پشتیبانی پیام بدید ✅",'HTML', $btnSupp);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '🪄 امتیاز روزانه' and $type === 'private')
{
    if (isJoin($from_id))
    {
        if ($user['refralsCount'] < 5)
        {
            sendMessage($from_id, '❌ برای امتیاز روزانه به پنج زیرمجموعه نیاز دارید','HTML');
            mysqli_close($db);
            exit(false);
        }
        if ($user['dayli'] > $time)
        {
            $min = timeUntil($user['dayli']);
            sendMessage($from_id, "❗️شما امتیاز روزانه خود را دریافت کرده اید!\n\n✅ برای دریافت مجدد {$min[0]} ساعت و {$min[1]} دقیقه دیگر به ربات سر بزنید",'HTML');
            mysqli_close($db);
            exit(false);
        }
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'dayli'"));
        if ($botSettings['type_id'] === 'off')
        {
            sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد','HTML');
            mysqli_close($db);
            exit(false);
        }
        $m = explode('-', $botSettings['columnOne']);
        $r = rand($m[0], $m[1]);
        $dayli = $time + 86400;
        sendMessage($from_id, "🎁 تبریک شما $r جام به عنوان امتیاز روازنه دریافت کردید و این مبلغ به حساب شما افزوده شد",'HTML');
        $db->query("UPDATE `user` SET `dayli` = '$dayli', `cup` = `cup` + {$r} WHERE `from_id` = '$from_id'");
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '❤️ ری اکشن زدن' and $type === 'private')
{
    if (isJoin($from_id))
    {
        if ($user['refralsCount'] < 3)
        {
            sendMessage($from_id, '❌ برای ریکشن زدن به سه زیرمجموعه نیاز دارید','HTML');
            mysqli_close($db);
            exit(false);
        }
        if ($user['reaction'] > 0)
        {
            sendMessage($from_id, "❗️شما ریکشن های این دوره را ثبت کرده اید! برای ثبت ریکشن در کانال جدید بعدا دوباره به ربات سر بزنید",'HTML');
            mysqli_close($db);
            exit(false);
        }
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'reaction'"));
        if ($botSettings['type_id'] === 'off')
        {
            sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد','HTML');
            mysqli_close($db);
            exit(false);
        }
        $channels = explode("\n", $botSettings['columnTwo']);
        $reaction = $botSettings['columnThree'];
        foreach ($channels as $channel) $button[] = [['text' => '📢 رفتن به کانال', 'url' => $channel]];
        $button[] = [['text' => '✅ تایید ریکشن ها', 'callback_data' => 'chechReactions']];
        $button = json_encode(['inline_keyboard' => $button]);
        sendMessage($from_id, "بعد از عضویت داخل هر چنل باید ده تا پست اخر رو ری اکشن [$reaction] بزنید؛ تا بابت هر کانال ({$botSettings['columnOne']}) جام به کیف پول شما افزوده شود",'HTML', $button);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '📢 عضویت در کانال ها' and $type === 'private')
{
    if (isJoin($from_id))
    {
        if ($user['refralsCount'] < 2)
        {
            sendMessage($from_id, '❌ برای عضویت در کانال ها به دو زیرمجموعه نیاز دارید','HTML');
            mysqli_close($db);
            exit(false);
        }
        if ($user['channel'] > 0)
        {
            sendMessage($from_id, "❗️شما چنل های این دوره را جویین شده اید! برای جویین شدن در  کانال جدید بعدا دوباره به ربات سر بزنید",'HTML');
            mysqli_close($db);
            exit(false);
        }
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'channels'"));
        if ($botSettings['type_id'] === 'off')
        {
            sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد','HTML');
            mysqli_close($db);
            exit(false);
        }
        $channels = explode("\n", $botSettings['columnTwo']);
        foreach ($channels as $channel) $button[] = [['text' => '📢 عضو شدن در کانال', 'url' => $channel]];
        $button[] = [['text' => '✅ بررسی عضویت', 'callback_data' => 'chechJoin']];
        $button = json_encode(['inline_keyboard' => $button]);
        sendMessage($from_id, "✅ بابت عضو شدن در هر کانال {$botSettings['columnOne']} جام به کیف پول شما اضافه خواهد شد",'HTML', $button);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '💸 شارژ کیف پول' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $coinUp = json_encode(['keyboard' => [[['text' => '💰 شارژ کیف پول با ارز']],[['text' => 'کارت به کارت 💳']],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, 'شما میتوانید از دو طریق کیف پول خود را شارژ کنید ⏬','markdown', $coinUp, $message_id);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '🎁 کد های تخفیف' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $codes = $db->query("SELECT * FROM `copon` ORDER BY `id` DESC LIMIT 10");
        if (mysqli_num_rows($codes) < 1)
        {
            sendMessage($from_id, '❌ در حال حاضر کد تخفیفی برای نمایش وجود ندارد');
            mysqli_close($db);
            exit(false); 
        }
        $TXT = "🧾 لیست آخرین کد های تخفیف موجود در ربات :\n\n";
        foreach ($codes as $code) $TXT .= "✅ کد تخفیف : <code>{$code['code']}</code>\n🔧 نوع : {$allTexts[$code['type']]}\n💸 مقدار : <b>{$code['amount']}</b>\n=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-\n";
        $TXT .= '❗️ برای کپی کردن هر کد کافی است روی ان کلیک کنید';
        sendMessage($from_id, $TXT,'HTML');
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '👥 زیرمجموعه گیری' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'refral'"));
        if ($botSettings['type_id'] === 'off')
        {
            sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد!');
            mysqli_close($db);
            exit(false);
        }
        $botInfo     = MahdyBots('getMe')->result;
        $usernamebot = $botInfo->username;
        $first_name  = htmlspecialchars($message->from->first_name ?? '');
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'refral'"));
        $pricee      = number_format($botSettings['columnOne']);
        $botText     = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `text`LIMIT 1"));
        $msgID       = SendPhoto($from_id, $botText['refrallink'], $botText['refral'] . "\n" . 'https://t.me/' . $usernamebot . '?start=' . $from_id, '', 'HTML')->result->message_id;
        sendMessage($from_id, "❤️ کاربر ($first_name) عزیز \nپیام بالا رو برای دوستان خود بفرستید و یا در گروه ها و کانال ها به اشتراک بگذارید در عوض هر کاربر که با لینک شما وارد ربات بشه و شماره خودش رو تایید کنه به حساب شما [ $pricee ] تومان 💸 اضافه میشه", 'HTML', '', $msgID);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === 'کارت به کارت 💳' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        if ($botSettings['type_id'] === 'off' or isset($user['number']))
        {
            sendMessage($from_id, '❗️مبلغ مورد نظر خود را جهت شارژ به تومان و با اعداد لاتین وارد کنید','HTML', $back_btn);
            $db->query("UPDATE `user` SET `step` = 'card' WHERE `from_id` = '$from_id'");        
        }
        else
        {
            deleteMessage($from_id, $message_id);
            $back_btn = json_encode(['keyboard' => [[['text'=>'✅ تایید شماره','request_contact' => true]],[['text' => '🔙']] ], 'resize_keyboard' => true]);
            sendMessage($from_id, '❗️شما هنوز شماره خود را تایید نکرده اید! با دکمه پایین شماره خود را تایید کنید و سپس اقدام به خرید فرمایید', null, $back_btn);
            $db->query("UPDATE `user` SET `step` = 'numbConfig' WHERE `from_id` = '$from_id'");
        }
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '💰 شارژ کیف پول با ارز' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $botSettings = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        if ($botSettings['type_id'] === 'off' or isset($user['number']))
        {
            if (empty(NowPayment))
            {
                sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد!');
                mysqli_close($db);
                exit(false);
            }
            $button[] = [['text' => '🔙']];
            sendMessage($from_id, "❤️ مبلغ مورد نظر خود را جهت شارژ به تومان وارد کنید\n⚠️ توجه کنید حداقل 10,000 تومان میتوانید وارد کنید", 'HTML', json_encode(['keyboard' => $button, 'resize_keyboard' => true]));
            $db->query("UPDATE `user` SET `step` = 'payDollar' WHERE `from_id` = '$from_id'");
        }
        else
        {
            deleteMessage($from_id, $message_id);
            $back_btn = json_encode(['keyboard' => [[['text'=>'✅ تایید شماره','request_contact' => true]],[['text' => '🔙']] ], 'resize_keyboard' => true]);
            sendMessage($from_id, '❗️شما هنوز شماره خود را تایید نکرده اید! با دکمه پایین شماره خود را تایید کنید و سپس اقدام به خرید فرمایید', null, $back_btn);
            $db->query("UPDATE `user` SET `step` = 'numbConfig' WHERE `from_id` = '$from_id'");
        }
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($text === '💰 کیف پول من' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $username    = $message->from->username ?? '';
        $first_name  = htmlspecialchars($message->from->first_name ?? '');
        $profile     = getUserProfilePhotos($from_id)->photos[0][0]->file_id;
        $userType    = $allTexts['type'][$user['type']];
        $balance     = number_format($user['balance']) . ' تومان';
        $pays        = number_format($user['pays']) . ' تومان';
        $cups        = number_format($user['cup']) . ' عدد';
        $refrals     = $user['refralsCount'] . ' نفر';
        $userTickets = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `Lottery` WHERE `user_id` = '$from_id'"));
        $userLot     = $userTickets['cup'] . ' شانس';
        $btn_profile = json_encode(['inline_keyboard' => [[['text' => '💰موجودی شما', 'callback_data' => 'none'], ['text' => $balance, 'callback_data' => 'none']],[['text' => '💳 پرداخت های شما', 'callback_data' => 'none'], ['text' => $pays, 'callback_data' => 'none']],[['text' => '💡 نوع حساب شما', 'callback_data' => 'none'], ['text' => $userType, 'callback_data' => 'none']],[['text' => '👥 تعداد زیرمجموعه های شما', 'callback_data' => 'none'], ['text' => $refrals, 'callback_data' => 'none']],[['text' => '🏆 تعداد جام های شما', 'callback_data' => 'none'],['text' => $cups, 'callback_data' => 'none']],[['text' => '✨ شانس های شما در قرعه کشی', 'callback_data' => 'none'], ['text' => $userLot, 'callback_data' => 'none']]]]);
        if ($profile) SendPhoto($from_id, $profile, "💭 حساب کاربری شما در ربات ما :\n\n👤 نام اکانت شما : <code>$first_name</code>\n🌟 یوزرنیم اکانت شما : <code>$username</code>\n🪪 ایدی عددی شما : <code>$from_id</code>", $message_id, 'HTML', $btn_profile);
        else sendMessage($from_id, "💭 حساب کاربری شما در ربات ما :\n\n👤 نام اکانت شما : <code>$first_name</code>\n🌟 یوزرنیم اکانت شما : <code>$username</code>\n🪪 ایدی عددی شما : <code>$from_id</code>", 'HTML', $btn_profile, $message_id);
        $coinUp = json_encode(['keyboard' => [[['text' => '👥 زیرمجموعه گیری']],[['text' => '💸 شارژ کیف پول']],[['text' => '🎁 کد های تخفیف']],[['text' => '✨ شرکت قرعه کشی']],[['text' => '🔙']]], 'resize_keyboard' => true]);
        sendMessage($from_id, '⏬ برای افزایش موجودی میتوانید یکی از روش های زیر ران انتخاب کنید','markdown', $coinUp, $message_id);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
if ($step === 'support' and $type === 'private')
{
    if (isJoin($from_id))
    {
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        copyMessage(SUP, $from_id, $message_id);
        sendMessage(SUP, "❗️یک پیام پشتیبانی جدید دریافت شد :\n\n📆 زمان دریافت پیام : $date\n🪪 آیدی فرستنده : <code>{$user['row']}</code>\n\n👇 برای پاسخ میتوانید از دکمه پایین استفاده کنید ", 'HTML', json_encode(['inline_keyboard' => [[['text' => '📨 ارسال پاسخ', 'callback_data' => 'answer_' . $from_id]]]]));
        sendMessage($from_id, "پیام شما باموفقیت برای پشتیبانی ارسال گردید ✅\n\nلطفا تا دریافت پاسخ صبور باشید 🌹", 'HTML', $btn_home);
    } else joinSend($from_id);
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'selectServer' and $type === 'private')
{
    if (!in_array($text, ['✅ فیلترشکن عادی', '🧨 فیلترشکن حرفه ای', '🔥 سرویس حجم نامحدود']))
    {
        sendMessage($from_id, '❗️ لطفا از  انتخاب کنید');
        mysqli_close($db);
        exit(false);
    }
    $panel = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `servers` WHERE `name` = '$text'"));
    if ($panel['status'] === 'off')
    {
        sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد، لطفا دسته دیگری را امتحان کنید');
        mysqli_close($db);
        exit(false);
    }
    $btns = $db->query("SELECT * FROM `button` WHERE `category` = '{$text}'");
    if (mysqli_num_rows($btns) < 1)
    {
        sendMessage($from_id, '❌ این بخش در حال شارژ میباشد لطفا دسته دیگری را امتحان کنید');
        mysqli_close($db);
        exit(false); 
    }
    $button[] = [['text' => '🛒 سرویس', 'callback_data' => 'none'],['text' => '💸 قیمت', 'callback_data' => 'none']];
    foreach ($btns as $btn)
    {
        $price = ($user['type'] === 'seller') ? $btn['price2'] : (($user['type'] === 'vipuser') ? $btn['price3'] : $btn['price']);
        $button[] = [['text' => $btn['name'], 'callback_data' => 'buyConfig-' . $btn['id']],['text' => number_format($price), 'callback_data' => 'none']];
    }
    if($text != '🔥 سرویس حجم نامحدود') $button[] = [['text' => '❗️اشتراکای بالا محدودیت کاربر نداره 🔥', 'callback_data' => 'noLimit']];
    $button[] = [['text' => '❌ بستن', 'callback_data' => 'start']];
    sendMessage($from_id, "❤️ به بخش خرید کانفیگ $text خوش آمدید! لطفا از بین کانفیگ های زیر یکی را انتخاب کنید :", 'MarkDown', json_encode(['inline_keyboard' => $button]), $message_id);
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'selectTestingServer' and $type === 'private')
{
    if (!in_array($text, ['✅ فیلترشکن عادی', '🧨 فیلترشکن حرفه ای', '🔥 سرویس حجم نامحدود']))
    {
        sendMessage($from_id, '❗️ لطفا از  انتخاب کنید');
        mysqli_close($db);
        exit(false);
    }
    $panel = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `servers` WHERE `name` = '$text'"));
    if ($panel['status'] === 'off')
    {
        sendMessage($from_id, '❌ این بخش موقتا خاموش میباشد، لطفا دسته دیگری را امتحان کنید');
        mysqli_close($db);
        exit(false);
    }
    $btns = $db->query("SELECT * FROM `button` WHERE `category` = '{$text}'");
    if (mysqli_num_rows($btns) < 1)
    {
        sendMessage($from_id, '❌ این بخش در حال شارژ میباشد لطفا دسته دیگری را امتحان کنید');
        mysqli_close($db);
        exit(false); 
    }
    $types = [
        '✅ فیلترشکن عادی' => 'free1',
        '🧨 فیلترشکن حرفه ای' => 'free2', 
        '🔥 سرویس حجم نامحدود' => 'free3'
    ];
    if ($user[$types[$text]] == 0)
    {
        sendMessage($from_id, '❌ شما تمامی تست های خود را دریافت کرده اید');
        mysqli_close($db);
        exit(false);
    }
    $panel = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `servers` WHERE `name` = '$text'"));
    $file  = $allTexts[$panel['type']];
    require_once "functions/$file.php";
    $config = createConfigTest($text);
    if ($config === false or is_array($config))
    {
        sendMessage(LOG, "❗️ مشکل در ساخت کانفیگ از پنل {$invoice['type']} ({$invoice['category']})\n\n⚠️ توضیحات ارسالی از پنل : {$config[1]}", 'HTML');
        sendMessage($from_id, '❌ ساخت کانفیگ با مشکل مواجه شد لطفا به پشتیبانی گزارش دهید', 'HTML');
        mysqli_close($db);
        exit(false);
    }
    $afText = mysqli_fetch_assoc($db->query("SELECT * FROM `options_data` WHERE `name` = '{$panel['type']}'"));
    sendMessage($from_id, $afText['content'], 'HTML', $btn_home);
    sendMessage($from_id, $config, 'HTML');
    $db->query("UPDATE `user` SET `step` = 'none', `{$types[$text]}` = 0 WHERE `from_id` = '$from_id'");
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'card' and $type === 'private')
{
    if (!is_numeric($text))
    {
        sendMessage($from_id,'اعداد را به لاتین وارد کنید ❗️','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    if ($text < 5000)
    {
        sendMessage($from_id,'حداقل مبلغ واریزی 5,000 تومان میباشد است','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    $C2C = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `cards` WHERE `type` = '{$user['type']}'"));
    $balance = number_format($text);
    $db->query("UPDATE `user` SET `step` = 'C2C_$text' WHERE `from_id` = '$from_id'");
    copyMessage($from_id, $C2C['card'], $C2C['name']);
    sendMessage($from_id, "✅ کاربر گرامی مبلغ $balance تومان را جهت افزایش موجودی به شماره کارت بالا واریز کرده و سپس از رسید خود اسکرین شات و یا عکس گرفته و برای ربات ارسال کنید\n\n❗️برای لغو عملیات روی دکمه زیر کلیک کنید", 'HTML', $back_btn);
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'payDollar' and $type === 'private')
{
    if (!is_numeric($text))
    {
        sendMessage($from_id,'اعداد را به لاتین وارد کنید ❗️','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    if ($text < 10000)
    {
        sendMessage($from_id,'حداقل مبلغ واریزی 10,000 تومان میباشد است','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    require_once 'lib/Currencies.php';
    foreach ($allCurrencies as $currencie) $button[] = [['text' => $currencie['name']]];
    $button[] = [['text' => '🔙']];
    $db->query("UPDATE `user` SET `code` = '$text', `step` = 'selectCurrencie' WHERE `from_id` = '$from_id'");
    sendMessage($from_id, '❤️ ارز مجازی (currencie) مورد نظر خود را برای پرداخت انتخاب کنید ', 'HTML', json_encode(['keyboard' => $button, 'resize_keyboard' => true]));
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'selectCurrencie' and $type === 'private')
{
    if (!isset($text))
    {
        sendMessage($from_id,'از کیبورد زیر استفاده کنید ❗️','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    require_once 'lib/Currencies.php';
    if (!isset($CurrenciesName[$text]))
    {
        sendMessage($from_id,'❌ ارز مجازی وارده یافت نشد!','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    $dollar = files_get('https://' . Domin . 'lib/dollar.php');
    if (!is_numeric($dollar))
    {
        sendMessage($from_id,'❌ خطایی رخ داده است لطفا دقایقی دیگر تلاش کنید','', $back_btn);
        mysqli_close($db);
        exit(false);
    }
    $payAmount = ($user['code'] / $dollar) * 1.05;
    $payAmount = round($payAmount, 2);
    $currencie = $allCurrencies[$CurrenciesName[$text]]['sym'];
    $link = 'https://' . Domin . 'paymemt/nowpayments.php?user=' . $from_id . '&amount=' . $payAmount . '&currencie=' . $currencie;
    $db->query("UPDATE `user` SET `code` = NULL, `step` = 'none' WHERE `from_id` = '$from_id'");
    sendMessage($from_id, "✅ فاکتور شما با موفقیت ایجاد شد\n\n⚠️ توجه کنید برای تایید پرداخت شما باید داخل صفحه پرداخت باقی بمانید و نباید پس از پرداخت از صفحه خارج شوید\n❗️پس از واریز به صفحه پرداخت برگردید و چند لحظه صبر کنید تا پرداخت شما تایید شود\n👤 در صورت بروز مشکل با پشتیبانی در تماس باشید", 'HTML', json_encode(['inline_keyboard' => [[['text' => '🧾 پرداخت', 'web_app' => ['url' => $link]]]]]));
    mysqli_close($db);
    exit(false);
}
elseif ($step === 'numbConfig' and $type === 'private')
{
    $contact = $message->contact ?? null;
	if (!isset($contact))
	{
        sendMessage($from_id, 'لطفا از کیبورد استفاده کنید ❕');
        mysqli_close($db);
        exit(false);
    }
    $contactid = $contact->user_id;
    if($contactid != $from_id)
    {
        sendMessage($from_id, 'از ارسال شماره دیگران خودداری کنید 🙏❗️');
        mysqli_close($db);
        exit(false);
    }
    $contactnum = $contact->phone_number;
    if(!preg_match('/^(98|\+98)(.*)/',$contactnum))
    {
		sendMessage($from_id, 'تنها کاربران ایرانی قادر به افزایش موجودی می باشند 🚫');
        mysqli_close($db);
        exit(false);
    }
    sendMessage($from_id, 'احراز هویت شما موفقیت آمیز بود ✅ ربات را مجددا استارت کنید : /start', 'HTML', $btn_home);
    $db->query("UPDATE `user` SET `number` = '$contactnum', `step` = 'none' WHERE `from_id` = '$from_id'");
    mysqli_close($db);
    exit(false);
}
elseif (preg_match('/^C2C_(.*)/', $step, $match) and $type === 'private')
{
    if (!isset($message->photo))
    {
        sendMessage($from_id, 'فقط عکس قابل قبول میباشد  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    $amount = number_format($match[1]);
    $confirmkey = json_encode(['inline_keyboard' => [[['text' => '✅ تایید', 'callback_data' => 'comfirm_' . $match[1] . '_' . $from_id]],[['text' => '❌ رد', 'callback_data' => 'reject_' . $match[1] . '_' . $from_id]]]]);
    copyMessage(PAY, $from_id, $message_id);
    sendMessage(PAY, "🧾 رسید جدید دریافت شد (⚠️ شارژ حساب)\n👤 آیدی فرستنده : `{$user['row']}`\n💸 مبلغ : $amount\n\n📆 تاریخ و زمان : $date", 'MarkDown',$confirmkey);
    sendMessage($from_id, "✅ رسید شما برای ادمین ارسال شد\n⚠️ تایید رسید ممکن است طول بکشد، لطفا صبور باشید\n\n❌ توجه لطفا از فرستادن مجدد این رسید یا پیام دادن به پشتیبانی برای زودتر تایید شدن رسیدتون خود داری کنید تا اختلالی تو این فرایند پیش نیاد.",'HTML', $btn_home);
    mysqli_close($db);
    exit(false);
}
elseif (preg_match('/^amount_(.*)/', $step, $match) and $type === 'private')
{
    if (!isset($message->photo))
    {
        sendMessage($from_id, 'فقط عکس قابل قبول میباشد  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    $invoice = mysqli_fetch_assoc($db->query("SELECT * FROM `invoices` WHERE `id` = '{$match[1]}'"));
    $service = mysqli_fetch_assoc($db->query("SELECT * FROM `button` WHERE `id` = '{$invoice['btn_id']}'"));
    $price   = ($user['type'] === 'seller') ? $service['price2'] : (($user['type'] === 'vipuser') ? $service['price3'] : $service['price']);
    $realPrice = $price;
    if (isset($invoice['copon'])) $price = addCopon($invoice['copon'], $price);
    $amount = number_format($price);
    $C2C = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `cards` WHERE `type` = '{$user['type']}'"));
    $confirmkey = json_encode(['inline_keyboard' => [[['text' => '✅ تایید', 'callback_data' => 'checked_' . $match[1] . '_' . $from_id]],[['text' => '❌ رد', 'callback_data' => 'reject_' . $match[1] . '_' . $from_id]]]]);
    copyMessage(PAY, $from_id, $message_id);
    sendMessage(PAY, "🧾 رسید جدید دریافت شد (⚠️ پرداخت مستقیم)\n📡 سرویس : {$service['category']}\n📢 کانفیگ : {$service['name']}\n👤 آیدی فرستنده : `{$user['row']}`\n💸 مبلغ : $amount\n✔️ مبلغ بدون اعمال کد تخفیف : $realPrice \n\n📆 تاریخ و زمان : $date", 'MarkDown',$confirmkey);
    sendMessage($from_id, "✅ رسید شما برای ادمین ارسال شد\n⚠️ تایید رسید ممکن است طول بکشد، لطفا صبور باشید\n\n❌ توجه لطفا از فرستادن مجدد این رسید یا پیام دادن به پشتیبانی برای زودتر تایید شدن رسیدتون خود داری کنید تا اختلالی تو این فرایند پیش نیاد.",'HTML', $btn_home);
    $db->query("UPDATE `invoices` SET `status` = 'wait' WHERE `id` = '{$match[1]}'");
    mysqli_close($db);
    exit(false);
}
elseif (preg_match('/^copon_(.*)/', $step, $match) and $type === 'private')
{
    if (!preg_match('/^[A-Za-z]+$/', $text)) 
    {
        sendMessage($from_id, 'فرمت کد ارسالی صحیح نیست  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    $copon = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `copon` WHERE `code` = '{$text}'"));
    if (!isset($copon['amount']))
    {
        sendMessage($from_id, 'کد ارسالی یافت نشد  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    if ($copon['usage'] < 1)
    {
        sendMessage($from_id, 'تعداد دفعات استفاده از کد شما به اتمام رسیده است  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    if ($copon['expiry_date'] < $time)
    {
        sendMessage($from_id, 'مهلت استفاده از کد شما ب اتمام رسیده است  ⚠️', 'HTML',$btn_home, $message_id);
        mysqli_close($db);
        exit(false);
    }
    $inserted_id = $match[1];
    $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    $db->query("UPDATE `copon` SET `usage` = `usage` - 1 WHERE `code` = '$text'");
    $invoice = mysqli_fetch_assoc($db->query("SELECT * FROM `invoices` WHERE `id` = '{$inserted_id}'"));
    $service = mysqli_fetch_assoc($db->query("SELECT * FROM `button` WHERE `id` = '{$invoice['btn_id']}'"));
    deleteMessage($from_id, $invoice['msg_id']);
    sendMessage($from_id, '✅ کد تخفیف شما با موفقیت اضافه شد','HTML', $btn_home);
    $cate = mysqli_fetch_assoc($db->query("SELECT * FROM `button` WHERE `id` = '{$invoice['btn_id']}'"));
    $price   = ($user['type'] === 'seller') ? $service['price2'] : (($user['type'] === 'vipuser') ? $service['price3'] : $service['price']);
    $price   = addCopon($text, $price);
    $btnVpnType  = json_encode(['inline_keyboard' => [[['text' => '💸 پرداخت مستقیم', 'callback_data' => 'invoice-pay-' . $inserted_id]],[['text' => '💰 پرداخت از کیف پول', 'callback_data' => 'invoice-buy-' . $inserted_id]],[['text' => '🎁 اعمال کد تخفیف', 'callback_data' => 'invoice-copon-' . $inserted_id]],[['text' => '❌ لغو و بازگشت', 'callback_data' => 'invoice-cancel-' . $inserted_id]]], 'resize_keyboard' => true]);
    $msg_id = sendMessage($from_id, "🧾 فاکتور شما با موفقیت ایجاد شد\n\n<b>{$cate['category']}</b>\n🔋 ترافیک درخواستی : <b>{$cate['traffick']}</b> گیگابایت\n📆 مدت زمان :<b>{$cate['time']} روز</b>\n💰 بها : <b>{$price}</b> تومان\n🎁 کد تخفیف : ($text)\n\n❤️ در صورتی که موارد فوق مورد تایید شما میباشند برای پرداخت روی یکی از گزینه ها کلیک کنید\n⚠️ این فاکتور فقط 20 دقیقه اعتبار دارد و در صورت پرداخت نکردن پس از 20 دقیقه لغو و فاغد اعتبار خواهد شد",'HTML', $btnVpnType)->result->message_id;
    $db->query("UPDATE `invoices` SET `copon` = '$text', `msg_id` = '$msg_id' WHERE `id` = '{$match[1]}'");
    mysqli_close($db);
    exit(false);
}
if (mysqli_num_rows($admin_sql) > 0)
{
    $admin_data = mysqli_fetch_assoc($admin_sql);
    if (($text === '👤 مدیریت' or $text === '/panel') and $type === 'private')
    {
        sendMessage($from_id, '👤 به منوی مدیریت ربات خود خوش امدید', 'MarkDown', $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none', `code` = NULL WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🔙 بازگشت' and $type === 'private')
    {
        sendMessage($from_id, "🌼 به منوی اصلی ربات برگشتیم \n\n🎉 برای استفاده از ربات از دکمه های زیر استفاده کنید", 'markdown', $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none', `code` = NULL WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🎁 کد تخفیف' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, '✅ برای مدیریت کد های تخفیف خود میتوانید از دکمه های پایین استفاده کنید', 'markdown', json_encode(['inline_keyboard' => [[['text' => '✅ ساخت کد تخفیف', 'web_app' => ['url' => 'https://' . Domin . 'lib/crCopons.php']]],[['text' => '❌ حذف کد تخفیف', 'web_app' => ['url' => 'https://' . Domin . 'lib/delCopons.php']]],[['text' => '🧾 مشاهده کد های تخفیف', 'web_app' => ['url' => 'https://' . Domin . 'lib/seeCopons.php']]]]]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '➕ افزودن کانفیگ' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, '✅ برای افزودن کانفیگ میتوانید از دکمه های پایین استفاده کنید', 'markdown', json_encode(['inline_keyboard' => [[['text' => '✅ افزودن کانفیگ', 'web_app' => ['url' => 'https://' . Domin . 'lib/InsertingBank.php']]],[['text' => '❌ حذف کانفیگ', 'web_app' => ['url' => 'https://' . Domin . 'lib/DeletingBank.php']]]]]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🕹 مدیریت دکمه ها' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $manage_btn = json_encode(['inline_keyboard' => [[['text' => '➖ حذف دکمه', 'callback_data' => 'removeBTN'],['text' => '➕ افزودن دکمه', 'callback_data' => 'AddBTN']],[['text' => '✔️ ویرایش دکمه', 'callback_data' => 'editBNT'],['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, "❤️ به بخش مدیریت دکمه های ربات خود خوش آمدید!\n\n❗️از این بخش میتوانید دکمه های بخش خرید را مدیریت کنید!\n✅ روی یکی از موارد زیر کلیک کنید برای", 'markdown', $manage_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🪄 بخش قرعه کشی' and $type === 'private')
    { 
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $manage_btn = json_encode(['inline_keyboard' => [[['text' => '💚 نمایش 5 نفر اول به ترتیب کاپ ها', 'callback_data' => 'top-5']],[['text' => '❤️ نمایش 10 نفر اول به ترتیب کاپ ها', 'callback_data' => 'top-10']],[['text' => '💙 نمایش 20 نفر اول به ترتیب کاپ ها', 'callback_data' => 'top-20']],[['text' => '🤍 نمایش یک برنده به صورت رندوم', 'callback_data' => 'top-rand']],[['text' => '🗑 خالی کردن لیست این سری از قرعه کشی', 'callback_data' => 'top-del']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, "❤️ به بخش قرعه کشی خوش آمدید!\n\n✅ از دکمه های پایین استفاده کنید :ی", 'markdown', $manage_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '💳 مدیریت کارت ها' and $type === 'private')
    { 
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $cards_btn = json_encode(['inline_keyboard' => [[['text' => '👤 کارت اعصای عادی', 'callback_data' => 'crad-user']],[['text' => '⭐️ کارت اعصای ویژه', 'callback_data' => 'crad-vipuser']],[['text' => '👥 کارت فروشندگان', 'callback_data' => 'crad-seller']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, "❤️ به بخش مدیریت کارت ها خوش آمدید!\n\n✅ از دکمه های پایین استفاده کنید :ی", 'markdown', $cards_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🖇 پیگیری پیام همگانی' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $send = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `send`"));
        if (!isset($send['step']))
        {
            sendMessage($from_id, 'در حال حاظر پیامی برای پیگیری وجود ندارد ❌ ');
            mysqli_close($db);
            exit(false);
        }
        $type = $allTexts[$send['step']];
        $usersCount = $send['user'];
        if ($send['step'] == 'for') ForwardMessage($from_id, $send['from'], $send['text']);
        else CopyMessage($from_id, $send['from'], $send['text']);
        sendMessage($from_id, "پیام بالا در حال $type همگانی است و تا کنون برای $usersCount یوزر $type شده است ☝🏻\nبرای لغو ادامه ارسال میتوانید روی دکمه پایین کلیک کنید ⏬", 'HTML', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]));
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '💰 گزارش مالی' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, '❤️درحال محاسبه پرداختی ها. صبور باشید . . . ');
        $countPays = number_format(mysqli_num_rows($db->query("SELECT * FROM `pay`")));
        if ($countPays < 1)
        {
            sendMessage($from_id, 'تا کنون پرداختی در ربات انجام نشده است ❌');
            mysqli_close($db);
            exit(false);
        }
        $payments = mysqli_num_rows($db->query("SELECT * FROM `settings` WHERE `type` = 'payments' AND `type_id` = 'on'"));
        $allPays = mysqli_fetch_assoc($db->query("SELECT SUM(amount) AS TotalAmount FROM pay"));
        sendMessage($from_id, "➕➖➖➖➖➖➖➖➖➖➕\n🧾 گزارش ارسالی در ساعت و تاریخ $date :\n\n📃 تعداد کل پرداخت ها : $countPays پرداخت\n💰 مجموع کل پرداخت ها : {$allPays['TotalAmount']} تومان\n💸 تعداد کل درگاه های روشن : $payments\n➕➖➖➖➖➖➖➖➖➖➕", 'MarkDown', $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '📝 بخش متن ها' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $set_txt_btn = json_encode(['inline_keyboard' => [[['text' => '💟 متن استارت', 'callback_data' => 'text_start'],['text' => '☮️ متن جویین اجباری', 'callback_data' => 'text_join']],[['text' => '✝️ متن تبلیغات پس از خرید', 'callback_data' => 'text_service'],['text' => '☪️ متن قرعه کشی', 'callback_data' => 'text_Lottery']],[['text' => '🕉 متن قرعه کشی 2', 'callback_data' => 'text_Lottery2'],['text' => '☸️ متن قرعه کشی 3', 'callback_data' => 'text_Lottery3']],[['text' => '♐️ متن فروشنده', 'callback_data' => 'text_selling'],['text' => '✡️ متن سرویس تست', 'callback_data' => 'text_test']],[['text' => '🔯 متن سوالات پر تکرار', 'callback_data' => 'text_faq'],['text' => '🕎 متن سوالات پر تکرار ویژه', 'callback_data' => 'text_faqvip']],[['text' => '☯️ متن ویژه شدن', 'callback_data' => 'text_vip'],['text' => '☦️ متن پشتیبانی ویژه', 'callback_data' => 'text_vipsup']],[['text' => '🛐 متن تبلیغات', 'callback_data' => 'text_ads'],['text' => '⛎ متن قوانین', 'callback_data' => 'text_ruls']],[['text' => '♈️ متن راهنما', 'callback_data' => 'text_help'],['text' => '♉️ متن زیرمجموعه گیری', 'callback_data' => 'text_refral']],[['text' => '♊️ عکس زیرمجموعه گیری', 'callback_data' => 'text_refrallink'],['text' => '♋️ متن پس از خرید', 'web_app' => ['url' => 'https://' . Domin . 'lib/typesText.php']]],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, '▪️ به منوی تنظیم متن های ربات  خوش آمدید از بین دکمه های زیر انتخاب کنید لطفا  :', 'MarkDown', $set_txt_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '👥 مدیریت ممبر ها' and $type === 'private')
    {
        $set_off_btn = json_encode(['inline_keyboard' => [[['text' =>'🚫 مسدود کردن', 'callback_data' => 'addblock'],['text' => '❇️ رفع مسدودیت', 'callback_data' => 'delblock']],[['text' => '➖ کاهش موجودی', 'callback_data' => 'balanceDown'],['text' => '➕ افزایش موجودی', 'callback_data' => 'balanceUp']],[['text' => '❗️اطلاعات ممبر', 'callback_data' => 'userinfo'],['text' => '🔎 پیدا کردن ممبر با آیدی', 'callback_data' => 'findUser']],[['text' => '📊 برترین ها', 'callback_data' => 'ShowTopUser'],['text' => '💸 موجودی همگانی', 'callback_data' => 'balanceAll']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, "▪️ به منوی مدیریت ممبر ها ربات  خوش آمدید از بین دکمه های زیر انتخاب کنید لطفا  :", 'MarkDown', $set_off_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '⚙️ تنظیمات' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        file_exists('OFF') ? $power = '❌' : $power = '✅';
        $numberConfig = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        $refral       = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'refral'"));
        $free         = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'free'"));
        $reaction     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'reaction'"));
        $dayli        = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'dayli'"));
        $cup          = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'cup'"));
        $channels     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'channels'"));
        $set_off_btn  = json_encode(['inline_keyboard' => [[['text' => '⚙️ تنظیمات', 'callback_data' => 'none'],['text' => '❕وضعیت کنونی', 'callback_data' => 'none']],[['text' => '🤖 ربات', 'callback_data' => 'offonbot'],['text' => $power, 'callback_data' => 'none']],[['text' => '🏆 جام به اضای خرید', 'callback_data' => 'setup_cup'],['text' => $allTexts[$cup['type_id']], 'callback_data' => 'none']],[['text' => '🏆 جایزه جام به اضای خرید', 'callback_data' => 'setting_cupl'],['text' => $cup['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '👥 زیرمجموعه گیری', 'callback_data' => 'setup_refral'],['text' => $allTexts[$refral['type_id']], 'callback_data' => 'none']],[['text' => '👥جایزه زیرمجموعه گیری', 'callback_data' => 'setting_refral'],['text' => $refral['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '💸 موجودی اولیه', 'callback_data' => 'setup_free'],['text' => $allTexts[$free['type_id']], 'callback_data' => 'none']],[['text' => '💸 مقدار موجودی اولیه', 'callback_data' => 'setting_free'],['text' => $free['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '🔥 ریکشن', 'callback_data' => 'setup_reaction'],['text' => $allTexts[$reaction['type_id']], 'callback_data' => 'none']],[['text' => '🔥 جایزه ریکشن', 'callback_data' => 'setting_reaction'],['text' => $reaction['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '🔥 کانال ریکشن', 'callback_data' => 'channelseting_reaction'],['text' => '📢', 'callback_data' => 'none']],[['text' => '📇 امتیاز روزانه', 'callback_data' => 'setup_dayli'],['text' => $allTexts[$dayli['type_id']], 'callback_data' => 'none']],[['text' => '📇 بازه امتیاز روزانه', 'callback_data' => 'setting_dayli'],['text' => $dayli['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 عضویت در کانال', 'callback_data' => 'setup_channels'],['text' => $allTexts[$channels['type_id']], 'callback_data' => 'none']],[['text' => '📢 جایزه عضویت در کانال', 'callback_data' => 'setting_channels'],['text' => $channels['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 کانال عضویت در کانال', 'callback_data' => 'channelseting_channels'],['text' => '📢', 'callback_data' => 'none']],[['text' => '☎️ تایید شماره', 'callback_data' => 'setup_numberConfig'],['text' => $allTexts[$numberConfig['type_id']], 'callback_data' => 'none']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, '▪️ به منوی تنظیمات ربات  خوش آمدید از بین دکمه های زیر انتخاب کنید لطفا  :', 'MarkDown', $set_off_btn, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '📡 مدیریت سرور ها' and $type === 'private')
    {
        sendMessage($from_id, '📡 برای مدیریت سرور های خود روی دکمه پایین کلیک کنید', 'HTML', json_encode(['inline_keyboard' => [[['text' => '📡 مدیریت سرور ها', 'web_app' => ['url' => 'https://' . Domin . 'lib/ServersEditing.php']]],[['text' => '📲 تست اتصال سرور ها', 'web_app' => ['url' => 'https://' . Domin . 'lib/ServersTesting.php']]]]]));
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '👤 امار ربات' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, '❤️درحال پردازش آمار. صبور باشید . . . ');
        $power             = file_exists('OFF') ? $allTexts['off'] : $allTexts['on'];
        $load              = sys_getloadavg();
        $ver               = phpversion();
        $usernamebot       = MahdyBots('getMe')->result->username;
        $countPays         = number_format(mysqli_num_rows($db->query("SELECT * FROM `pay`")));
        $refral            = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'refral'"));
        $free              = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'free'"));
        $cup               = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'cup'"));
        $reaction          = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'reaction'"));
        $dayli             = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'dayli'"));
        $channels          = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'channels'"));
        $numberConfig      = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        $countAdmins       = number_format(mysqli_num_rows($db->query("SELECT * FROM `settings` WHERE `type` = 'admin'")));
        $countChannels     = number_format(mysqli_num_rows($db->query("SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false'")));
        $countUsers        = number_format(mysqli_num_rows($db->query("SELECT * FROM `user`")));
        $countOnlinesNow   = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > $time - 60")) ?? 0);
        $countOnlinesClock = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > $time - 3600")) ?? 0);
        $countOnlinesDay   = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > $time - 86400")) ?? 0);
        $countOnlinesWeek  = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > $time - 604800")) ?? 0);
        $countOnlinesMonth = number_format(mysqli_num_rows($db->query("SELECT * FROM `user` WHERE `update_at` > $time - 2419200")) ?? 0);
        $countUsersBlocked = number_format(mysqli_num_rows($db->query("SELECT * FROM `block`")));
        sendMessage($from_id, "📊 آمار ربات شما :
➕➖➖➖➖➖➖➖➖➖➕
👥 تعداد اعضا : `$countUsers`
📲 تعداد کاربران آنلاین : `$countOnlinesNow`
⌚️ تعداد کاربران ساعت گذشته : `$countOnlinesClock`
🌃 تعداد کاربران 24 ساعت گذشته : `$countOnlinesDay`
📆 تعداد کاربران هفته گذشته : `$countOnlinesWeek`
🌒 تعداد کاربران ماه گذشته : `$countOnlinesMonth`
➕➖➖➖➖➖➖➖➖➖➕
🚫 تعداد کاربران بلاک شده : `$countUsersBlocked`
➕➖➖➖➖➖➖➖➖➖➕
👨🏻‍💻 تعداد ادمین ها : `$countAdmins`
📢 تعداد کانال ها : `$countChannels`
➕➖➖➖➖➖➖➖➖➖➕
💳 تعداد کل پرداخت ها : `$countPays`
➕➖➖➖➖➖➖➖➖➖➕
👥 زیرمجموعه گیری : `{$allTexts[$refral['type_id']]}`
👥 جایزه زیرمجموعه گیری : `{$refral['columnOne']}`
🏆 جام به اضای خرید : `{$allTexts[$cup['type_id']]}`
🏆 جایزه جام به اضای خرید : `{$cup['columnOne']}`
🔥 ریکشن : `{$allTexts[$reaction['type_id']]}`
🔥 جایزه ریکشن : `{$reaction['columnOne']}`
📇 امتیاز روزانه : `{$allTexts[$dayli['type_id']]}`
📇 بازه امتیاز روزانه : `{$dayli['columnOne']}`
📢 کانال جویین اجباری : `{$allTexts[$channels['type_id']]}`
📢 جایزه کانال جویین اجباری : `{$channels['columnOne']}`
☎️ تایید شماره : `{$allTexts[$numberConfig['type_id']]}`
🌐 وضعیت ربات  : `$power`
➕➖➖➖➖➖➖➖➖➖➕
📡 لود سرور : `{$load[0]}`
🐘 ورژن php سرور : `$ver`
➕➖➖➖➖➖➖➖➖➖➕
🕐  گزارش ارسال شده در ساعت و تاریخ `$date`", 'MarkDown', $panel, $message_id);
    mysqli_close($db);
    exit(false);
    }
    elseif ($text === '📫 بخش ارسال پیام' and $type === 'private')
    {
        sendMessage($from_id, 'به بخش ( 📫 بخش ارسال پیام ) خوش امدید لطفا با استفاده از دکمه های زیر ادامه دهید.', 'MarkDown', json_encode(['keyboard' => [[['text' => '📪 ارسال به همه'], ['text' => '📪 فوروارد به همه']],[['text' => '📨  ارسال به کاربر'], ['text' => '🖇 پیگیری پیام همگانی']],[['text' => '🔙 بازگشت']]], 'resize_keyboard' => true]) , $message_id);
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '📪 ارسال به همه' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $send = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `send`"));
        if ($send['step']) sendMessage($from_id, "یک پیام در صف ارسال قرار دارد ⚠️ در صورت تمایل ب لغو پیام روی دکمه پایین کلیک کنید و یا تا پایان ارسال صبر کنید! پس از پایان ربات برای شما پیام خاتمه را ارسال خواهد کرد!!", 'MarkDown', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]), $message_id);
        else
        {
            $DLonoff = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'sending'"));
            $send_panel = json_encode(['inline_keyboard' => [[['text' => '📍پین (' . $allTexts[$DLonoff['type_id']] . ')', 'callback_data' => 'sending-type_id']], [['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
            sendMessage($from_id, "▪️ لطفا پیام خود را ارسال کنید :", 'MarkDown', $send_panel, $message_id);
            $db->query("UPDATE `user` SET `step` = 'sendAll' WHERE `from_id` = '$from_id'");
        }
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '📨  ارسال به کاربر' and $type === 'private')
    {
        sendMessage($from_id, 'در خط اول آیدی کاربر و در خط دوم متن مورد نظر خود را ارسال کنید', 'MarkDown', $btn_back, $message_id);
        $db->query("UPDATE `user` SET `step` = 'senUser' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '📪 فوروارد به همه' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $send = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `send`"));
        if ($send['step']) sendMessage($from_id, "یک پیام در صف ارسال قرار دارد ⚠️ در صورت تمایل ب لغو پیام روی دکمه پایین کلیک کنید و یا تا پایان ارسال صبر کنید! پس از پایان ربات برای شما پیام خاتمه را ارسال خواهد کرد!!", 'MarkDown', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]), $message_id);
        else
        {
            $DLonoff = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'sending'"));
            $send_panel = json_encode(['inline_keyboard' => [[['text' => '📍پین (' . $allTexts[$DLonoff['type_id']] . ')', 'callback_data' => 'sending-type_id']], [['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
            sendMessage($from_id, "▪️ لطفا پیام خود را ارسال کنید :", 'MarkDown', $send_panel, $message_id);
           $db->query("UPDATE `user` SET `step` = 'forAll' WHERE `from_id` = '$from_id'");
        }
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🔒 بخش قفل ها' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $lockSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'lock' AND `type_id` != 'false'");
        if (mysqli_num_rows($lockSQL) > 0)
        {
            $lockText = "☑️ به بخش (🔒 بخش قفل ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - 🔗 برای تعییر لینک روی دکمه ی ( ⚙️ ) بزنید \n4 - برای افزودن قفل روی دکمه ی ( ➕ افزودن قفل ) بزنید";
            $button[] = [['text' => '🗝 نام قفل', 'callback_data' => 'none'], ['text' => '⚙️ تغییر لینک', 'callback_data' => 'none'], ['text' => '🗑 حذف', 'callback_data' => 'none']];
            foreach ($lockSQL as $item) 
            {
                $lock = getChat($item['type_id'])->result;
                if ($lock === false) continue;
                $name = $lock->title;
                $link = $item['columnTwo'] ? : $lock->invite_link;
                if (!$link)
                {
                    $name = 'دسترسی ندارد';
                    $link = 'https://t.me/username';
                }
                $button[] = [['text' => $name, 'url' => $link], ['text' => '⚙️', 'callback_data' => "change_lock_{$item['type_id']}"], ['text' => '🗑', 'callback_data' => "remove_lock_{$item['type_id']}"]];
            }
        } else $lockText = '❌ شما قفلی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( ➕ افزودن قفل ) اضافه کنید.';
        $button[] = [['text' => '➕ افزودن قفل', 'callback_data' => 'addLock'], ['text' => '➕ افزودن قفل فیک', 'callback_data' => 'addFakeLock']];
        $button[] = [['text' => '(🔙) برگشت', 'callback_data' => 'panel']];
        sendMessage($from_id, $lockText, null, json_encode(['inline_keyboard' => $button]) , $message_id);
        mysqli_close($db);
        exit(false);
    }
    elseif ($text === '🧑🏻‍💻 بخش ادمین ها' and $type === 'private')
    {
        if ($admin_data['columnOne'] != 'owner')
        {        
            sendMessage($from_id, '❌ شما دسترسی به این بخش ندارید.', null, $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $adminsSQL = $db->query("SELECT * FROM `settings` WHERE `type` = 'admin' AND `columnOne` != 'owner'");
        if (mysqli_num_rows($adminsSQL) > 0)
        {
            $adminsText = "☑️ به بخش (🧑🏻‍💻 بخش ادمین ها) خوش امدید\n\n🚦 راهنما :\n1 - 👁 برای مشاهده ی هر کدام روی اسم ان ادمین بزنید.\n2 - برای حذف هر کدام روی دکمه ی ( 🗑 ) بزنید\n3 - برای افزودن ادمین روی دکمه ی ( ➕ افزودن ادمین ) بزنید";
            $button[] = [['text' => '🧑🏻‍💻 نام ادمین', 'callback_data' => 'none'], ['text' => '🗑 حذف', 'callback_data' => 'none']];
            foreach ($adminsSQL as $item) 
            {
                $name = getChat($item['type_id'])->result->first_name;
                if (!$name) $name = 'یافت نشد';
                $button[] = [['text' => $name, 'url' => "tg://openmessage?user_id={$item['type_id']}"], ['text' => '🗑', 'callback_data' => "remove_ad_{$item['type_id']}"]];
            }
        } else $adminsText = '❌ شما ادمینی برای حذف و مشاهده ندارید لطفا از طریق دکمه ی ( ➕ افزودن ادمین ) اضافه کنید.';
        $button[] = [['text' => '➕ افزودن ادمین', 'callback_data' => 'addAdmin'], ['text' => '🔙 بازگشت', 'callback_data' => 'panel']];
        sendMessage($from_id, $adminsText, null, json_encode(['inline_keyboard' => $button]) , $message_id);
        mysqli_close($db);
        exit(false);
    }
    if ($step === 'UnBan' and $type === 'private')
    {
        if (!is_numeric($text))
        {
            sendMessage($from_id, '❗️ لطفا اعداد را لاتین وارد کنید');
            mysqli_close($db);
            exit(false);
        }
        $isBlocked = $db->query("SELECT * FROM `block` WHERE `user_id` = '$text'");
        if (mysqli_num_rows($isBlocked) < 1)
        {
            sendMessage($from_id, '❗️کاربر در لیست بلاک ربات نیست');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "کاربر $text با موفقیت رفع بلاک شد ❇️", 'MarkDown', $panel, $message_id);
        sendMessage($text, 'شما توسط ادمین رفع بلاک شدید ❇️', 'MarkDown');
        $db->query("DELETE FROM `block` WHERE `user_id` = '$text'");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'Ban' and $type === 'private')
    {
        if (!is_numeric($text))
        {
            sendMessage($from_id, '❗️ لطفا اعداد را لاتین وارد کنید');
            mysqli_close($db);
            exit(false);
        }
        if ($text == $from_id)
        {
            sendMessage($from_id, '❗️ شما نمیتوانید خودتان را بلاک کیند');
            mysqli_close($db);
            exit(false);
        }
        $isBlocked = $db->query("SELECT * FROM `block` WHERE `user_id` = '$text'");
        if (mysqli_num_rows($isBlocked) > 0)
        {
            sendMessage($from_id, '❗️کاربر در لیست بلاک ربات قرار دارد', 'HTML', $panel);
            mysqli_close($db);
            exit(false);
        }
        $isAdmin = $db->query("SELECT `type_id`,`columnOne` FROM `settings` WHERE `type` = 'admin' AND `type_id` = '$text' LIMIT 1");
        if (mysqli_num_rows($isAdmin) > 0)
        {
            sendMessage($from_id, "شما نمیتوانید ادمین ها را مسدود کنید ‼️", 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "کاربر $text با موفقیت بلاک شد 🚫", 'MarkDown', $panel, $message_id);
        sendMessage($text, 'شما توسط ادمین بلاک شدید 🚫', 'MarkDown');
        $db->query("INSERT INTO `block` (`user_id`) VALUES ('$text')");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'editBNT' and $type === 'private')
    {
        if (!in_array($text, ['✅ فیلترشکن عادی', '🧨 فیلترشکن حرفه ای', '🔥 سرویس حجم نامحدود']))
        {
            sendMessage($from_id, "❗️لطفا از کیبورد زیر انتخاب کنید.\nیا روی 👈 /start بزنید تا به صفحه اصلی برگردید");
            mysqli_close($db);
            exit(false);
        }
        $btns = $db->query("SELECT * FROM `button` WHERE `category` = '{$text}'");
        foreach ($btns as $btn) $button[] = [['text' => $btn['name'], 'callback_data' => 'editeBTN-' . $btn['id']]];
        $button[] = [['text' => '❌ بستن', 'callback_data' => 'panel']];
        sendMessage($from_id, '❗️ اکنون از بین دکمه های پایین روی دکمه ای ک میخواهید ویرایش شود کلیک کنید', 'MarkDown', json_encode(['inline_keyboard' => $button]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'removeBTN' and $type === 'private')
    {
        if (!in_array($text, ['✅ فیلترشکن عادی', '🧨 فیلترشکن حرفه ای', '🔥 سرویس حجم نامحدود']))
        {
            sendMessage($from_id, "❗️لطفا از کیبورد زیر انتخاب کنید.\nیا روی 👈 /start بزنید تا به صفحه اصلی برگردید");
            mysqli_close($db);
            exit(false);
        }
        $btns = $db->query("SELECT * FROM `button` WHERE `category` = '{$text}'");
        foreach ($btns as $btn) $button[] = [['text' => $btn['name'], 'callback_data' => 'deleteBTN-' . $btn['id']]];
        $button[] = [['text' => '❌ بستن', 'callback_data' => 'panel']];
        sendMessage($from_id, "❗️ اکنون از بین دکمه های پایین روی دکمه ای ک میخواهید حذف شود کلیک کنید\n\n⚠️ توجه کنید این عمل غیر قابل بازگشت میباشد", 'MarkDown', json_encode(['inline_keyboard' => $button]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'AddBTN' and $type === 'private')
    {
        if (!in_array($text, ['✅ فیلترشکن عادی', '🧨 فیلترشکن حرفه ای', '🔥 سرویس حجم نامحدود']))
        {
            sendMessage($from_id, "❗️لطفا از کیبورد زیر انتخاب کنید.\nیا روی 👈 /start بزنید تا به صفحه اصلی برگردید");
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "✅حالا در یک پیام تمامی موارد خواسته شده را ارسال کنید :\nاسم دکمه\nقیمت اصلی\nقیمت فروشندگان\nقیمت ویژه\nمدت زمان به روز\nترافیک به گیگابایت\n\nمثال :\n20 گیگ 1 کاربره یک ماهه\n20000\n15000\n15000\n30\n20", 'MarkDown', $panel, $message_id);
        $db->query("INSERT INTO `button` (`category`, `creat_at`, `user_id`) VALUES ('$text', '$time', '$from_id')");
        $db->query("UPDATE `user` SET `step` = 'AddBTN2', `code` = NULL WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'AddBTN2' and $type === 'private')
    {
        $datas = explode("\n", $text);
        if (!is_numeric($datas[1]) or !is_numeric($datas[2]) or !is_numeric($datas[3]) or !is_numeric($datas[4]) or !is_numeric($datas[5]))
        {
            sendMessage($from_id, '❗️ لطفا از اعداد لاتین استفاده کنید');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, '✅ با موفقیت ثبت شد', 'MarkDown', $panel, $message_id);
        if (isset($user['code'])) $inserted['MaxID'] = $user['code'];
        else $inserted = mysqli_fetch_assoc($db->query("SELECT MAX(id) AS MaxID FROM `button`"));
        $db->query("UPDATE `button` SET `name` = '{$datas[0]}', `price` = '{$datas[1]}', `price2` = '{$datas[2]}', `price3` = '{$datas[3]}',`time` = '{$datas[4]}', `traffick` = '{$datas[5]}' WHERE `id` = '{$inserted['MaxID']}'");
        $db->query("UPDATE `user` SET `step` = 'none', `code` = NULL WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'findUser' and $type === 'private')
    {
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `row` = '{$text}'"));
        if(!isset($usr_info['from_id']))
        {
            sendMessage($from_id, '404! یوزر پیدا نشد ❗️', 'MarkDown', $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "🧾 آیدی عددی کاربر <code>{$usr_info['from_id']}</code>", 'HTML');
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    }
    elseif ($step === 'userinfo' and $type === 'private')
    {
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `from_id` = '{$text}'"));
        if(!isset($usr_info['row']))
        {
            sendMessage($from_id, '404! یوزر پیدا نشد ❗️', 'MarkDown', $panel, $message_id);
            mysqli_close($db);
            exit(false);
        }
        $usesrget   = getChat($text);
        $name       = htmlspecialchars($usesrget->result->first_name);
        $username   = $usesrget->result->username;
        $numCnfg    = json_encode(['inline_keyboard' => [[['text' => '✅ معاف کردن کاربر از تایید شماره', 'callback_data' => 'NumCnfg_' . $text]],[['text' => '👤 تغییر به ممبر عادی', 'callback_data' => 'type_user_' . $text]],[['text' => '⭐️ تغییر به ممبر ویژه', 'callback_data' => 'type_vipuser_' . $text]],[['text' => '👥 تغییر به همکار', 'callback_data' => 'type_seller_' . $text]]]]);
        sendMessage($from_id, "🧾 اطلاعات کاربر <code>$text</code> :\n👤 اسم کاربر : <code>$name</code>\n☑️ یوزرنیم کاربر : @$username\n💳 پرداخت های کاربر : <b>{$usr_info['pays']}</b> تومان\n💰 موجودی کنونی کاربر : {$usr_info['balance']} تومان\n☎️ شماره کاربر : <code>{$usr_info['number']}</code>\n👥 زیرمجموعه های کاربر : {$usr_info['refralsCount']}\n✅ تاریخ پیوستن به ربات : {$usr_info['started']}", 'HTML', $numCnfg);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
    }
    elseif ($step === 'balanceUp' and $type === 'private')
    {
        $usr_inf = explode("\n", $text);
        if (!is_numeric($usr_inf[0]) or !is_numeric($usr_inf[1]))
        {
            sendMessage($from_id, '❌خطا ! مقادیر را با اعداد لاتین وارد کنید', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        if ($admin_data['columnOne'] != 'owner') $col = 'row';
        else $col = 'from_id';
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `$col` = '{$usr_inf[0]}'"));
        if (!isset($usr_info['row']))
        {
            sendMessage($from_id, '❌خطا ! کاربر پیدا نشد', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "موجودی کاربر {$usr_inf[0]} با موفقیت افزایش یافت ❇️", 'MarkDown', $panel, $message_id);
        sendMessage($usr_info['from_id'], "از طرف ادمین برای شما مبلغ {$usr_inf[1]} تومان ارسال شد ❇️", 'MarkDown');
        $db->query("UPDATE `user` SET `balance` = `balance` + {$usr_inf[1]} WHERE `$col` = '{$usr_inf[0]}'");
        $new = $usr_info['balance'] + $usr_inf[1];
        sendMessage(LOG, "Balance updated successfully :\nUser ($col): {$usr_inf[0]}\nSended Balance : {$usr_inf[1]}\nNew Balance : {$new}\nAdmin : $from_id");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'balanceDown' and $type === 'private')
    {
        $usr_inf = explode("\n", $text);
        if (!is_numeric($usr_inf[0]) or !is_numeric($usr_inf[1]))
        {
            sendMessage($from_id, '❌خطا ! مقادیر را با اعداد لاتین وارد کنید', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        if ($admin_data['columnOne'] != 'owner') $col = 'row';
        else $col = 'from_id';
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `$col` = '{$usr_inf[0]}'"));
        if (!isset($usr_info['row']))
        {
            sendMessage($from_id, '❌خطا ! کاربر پیدا نشد', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($from_id, "موجودی کاربر {$usr_inf[0]} با موفقیت کاهش یافت ❇️", 'MarkDown', $panel, $message_id);
        sendMessage($usr_info['from_id'], "از طرف ادمین از شما مبلغ {$usr_inf[1]} تومان کسر شد ❇️", 'MarkDown');
        $db->query("UPDATE `user` SET `balance` = `balance` - {$usr_inf[1]} WHERE `$col` = '{$usr_inf[0]}'");
        $new = $usr_info['balance'] - $usr_inf[1];
        sendMessage(LOG, "Balance updated successfully :\nUser ($col): {$usr_inf[0]}\nSended Balance : -{$usr_inf[1]}\nNew Balance : {$new}\nAdmin : $from_id");
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'balanceAll' and $type === 'private')
    {
        $datas = explode("\n", $text);
        if (count($datas) < 2)
        {
            sendMessage($from_id, '❌خطا ! الگوی ارسال را رعایت کنید', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        if (!is_numeric($datas[0]))
        {
            sendMessage($from_id, '❌خطا ! اعداد را به لاتین وارد کنید', 'MarkDown');
            mysqli_close($db);
            exit(false);
        }
        $countUsers = mysqli_num_rows($db->query("SELECT * FROM `user`"));
        $sendTime = $countUsers / 100;
        sendMessage($from_id, "پیام شما با موفقیت برای ارسال همگانی تنظیم شد ✔️ ارسال شما حدودا $sendTime دقیقه طول میکشد! در صورت تمایل به لغو ارسال روی دکمه پایین کلیک کنید", 'MarkDown', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES('Balance', '{$datas[0]}', '{$datas[1]}', 0);");
    }
    elseif ($step === 'sendAll' and $type === 'private')
    {
        $countUsers = mysqli_num_rows($db->query("SELECT * FROM `user`"));
        $sendTime = $countUsers / 100;
        sendMessage($from_id, "پیام شما با موفقیت برای ارسال همگانی تنظیم شد ✔️ ارسال شما حدودا $sendTime دقیقه طول میکشد! در صورت تمایل به لغو ارسال روی دکمه پایین کلیک کنید", 'MarkDown', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES('send', '$message_id', '$from_id', 0);");
    }
    elseif ($step === 'addFakeLock' and $type === 'private')
    {
        sendMessage($from_id, '✅ با موفقیت تنظیم شد', 'MarkDown', $panel, $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        if ($text == '00') $db->query("UPDATE `settings` SET `type_id` = 'off' WHERE `type` = 'fake'");
        else
        {
            $explode = explode("\n", $text);
            $db->query("UPDATE `settings` SET `type_id` = 'on', `columnTwo` = '{$explode[0]}', `columnThree` = '{$explode[1]}' WHERE `type` = 'fake'");
        }
    }
    elseif ($step === 'senUser' and $type === 'private')
    {
        sendMessage($from_id, '✅ با موفقیت ارسال شد.', null, $panel, $message_id);
        $txt = $text ?? $message->caption;
        $file_id = $message->photo[0]->file_id ?? '';
        $sending = explode("\n", $txt);
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `row` = '{$sending[0]}'"));
        $counting = count($sending);
        for ($x = 1; $x <= $counting; $x++) $msg = $msg . "\n" . $sending[$x];
        if(isset($message->caption)) SendPhoto($usr_info['from_id'], $file_id, "پیام مدیریت برای شما\n$msg", NULL, 'HTML');
        else sendMessage($usr_info['from_id'], "پیام مدیریت برای شما\n$msg", null);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'forAll' and $type === 'private')
    {
        $countUsers = mysqli_num_rows($db->query("SELECT * FROM `user`"));
        $sendTime = $countUsers / 100;
        sendMessage($from_id, "پیام شما با موفقیت برای ارسال همگانی تنظیم شد ✔️ ارسال شما حدودا $sendTime دقیقه طول میکشد! در صورت تمایل به لغو ارسال روی دکمه پایین کلیک کنید", 'MarkDown', json_encode(['inline_keyboard' => [[['text' => 'لغو پیام همگانی ❌', 'callback_data' => 'cancelSend']]]]), $message_id);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        $db->query("INSERT INTO `send` (`step`, `text`, `from`, `user`) VALUES('for', '$message_id', '$from_id', 0);");
        mysqli_close($db);
        exit(false);
    }
    elseif ($step === 'addAdmin' and $type === 'private')
    {
        $userP = mysqli_fetch_assoc($db->query("SELECT * FROM `user` WHERE `from_id` = '$text'"));
        if ($userP)
        {
            $name = getChat($userP['from_id'])->result->first_name;
            if (mysqli_num_rows($db->query("SELECT * FROM `settings` WHERE `type_id` = '{$userP['from_id']}' AND `type` = 'admin'")) == 0)
            {
                sendMessage($from_id, "✅ با موفقیت به ادمین ها اضافه شد.\n\n👤 نام کاربر : $name\n🆔 ایدی عددی کاربر : {$userP['from_id']}", null, $panel, $message_id);
                sendMessage($userP['from_id'], "✅ شما با موفقیت به ادمین های ربات اضافه شدید لطفا ربات رو استارت کنید.\n/start");
                $db->query("INSERT INTO `settings` (`type`, `type_id`, `columnOne`) VALUES ('admin', '$text', 'admin')");
                $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
            } else sendMessage($from_id, '❌ کاربر از قبل ادمین ربات است. لطفا ایدی دیگری بفرستید', null, $btn_back, $message_id);
        } else sendMessage($from_id, '❌ کاربر ربات را استارت نکرده است. لطفا ایدی دیگری بفرستید', null, $btn_back, $message_id);
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^text_(.*)/', $step, $match) and $type === 'private')
    {
        deleteMessage($from_id, $message_id - 1);
        $set_txt_btn = json_encode(['inline_keyboard' => [[['text' => '💟 متن استارت', 'callback_data' => 'text_start'],['text' => '☮️ متن جویین اجباری', 'callback_data' => 'text_join']],[['text' => '✝️ متن تبلیغات پس از خرید', 'callback_data' => 'text_service'],['text' => '☪️ متن قرعه کشی', 'callback_data' => 'text_Lottery']],[['text' => '🕉 متن قرعه کشی 2', 'callback_data' => 'text_Lottery2'],['text' => '☸️ متن قرعه کشی 3', 'callback_data' => 'text_Lottery3']],[['text' => '♐️ متن فروشنده', 'callback_data' => 'text_selling'],['text' => '✡️ متن سرویس تست', 'callback_data' => 'text_test']],[['text' => '🔯 متن سوالات پر تکرار', 'callback_data' => 'text_faq'],['text' => '🕎 متن سوالات پر تکرار ویژه', 'callback_data' => 'text_faqvip']],[['text' => '☯️ متن ویژه شدن', 'callback_data' => 'text_vip'],['text' => '☦️ متن پشتیبانی ویژه', 'callback_data' => 'text_vipsup']],[['text' => '🛐 متن تبلیغات', 'callback_data' => 'text_ads'],['text' => '⛎ متن قوانین', 'callback_data' => 'text_ruls']],[['text' => '♈️ متن راهنما', 'callback_data' => 'text_help'],['text' => '♉️ متن زیرمجموعه گیری', 'callback_data' => 'text_refral']],[['text' => '♊️ عکس زیرمجموعه گیری', 'callback_data' => 'text_refrallink'],['text' => '♋️ متن پس از خرید', 'web_app' => ['url' => 'https://' . Domin . 'lib/typesText.php']]],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, 'متن با موفقیت ست شد ✅', 'HTML', $set_txt_btn);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '{$from_id}'");
        $db->query("UPDATE `text` SET `{$match[1]}` = '$text'LIMIT 1");
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^channelseting_(.*)/', $step, $match) and $type === 'private')
    {
        $db->query("UPDATE `settings` SET `columnTwo` = '$text' WHERE `type` = '{$match[1]}'");
        $db->query("UPDATE `user` SET `{$match[1]}` = '0'");
        deleteMessage($from_id, $message_id - 1);
        file_exists('OFF') ? $power = '❌' : $power = '✅';
        $numberConfig = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        $refral       = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'refral'"));
        $free         = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'free'"));
        $reaction     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'reaction'"));
        $dayli        = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'dayli'"));
        $cup          = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'cup'"));
        $channels     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'channels'"));
        $set_off_btn  = json_encode(['inline_keyboard' => [[['text' => '⚙️ تنظیمات', 'callback_data' => 'none'],['text' => '❕وضعیت کنونی', 'callback_data' => 'none']],[['text' => '🤖 ربات', 'callback_data' => 'offonbot'],['text' => $power, 'callback_data' => 'none']],[['text' => '🏆 جام به اضای خرید', 'callback_data' => 'setup_cup'],['text' => $allTexts[$cup['type_id']], 'callback_data' => 'none']],[['text' => '🏆 جایزه جام به اضای خرید', 'callback_data' => 'setting_cupl'],['text' => $cup['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '👥 زیرمجموعه گیری', 'callback_data' => 'setup_refral'],['text' => $allTexts[$refral['type_id']], 'callback_data' => 'none']],[['text' => '👥جایزه زیرمجموعه گیری', 'callback_data' => 'setting_refral'],['text' => $refral['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '💸 موجودی اولیه', 'callback_data' => 'setup_free'],['text' => $allTexts[$free['type_id']], 'callback_data' => 'none']],[['text' => '💸 مقدار موجودی اولیه', 'callback_data' => 'setting_free'],['text' => $free['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '🔥 ریکشن', 'callback_data' => 'setup_reaction'],['text' => $allTexts[$reaction['type_id']], 'callback_data' => 'none']],[['text' => '🔥 جایزه ریکشن', 'callback_data' => 'setting_reaction'],['text' => $reaction['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '🔥 کانال ریکشن', 'callback_data' => 'channelseting_reaction'],['text' => '📢', 'callback_data' => 'none']],[['text' => '📇 امتیاز روزانه', 'callback_data' => 'setup_dayli'],['text' => $allTexts[$dayli['type_id']], 'callback_data' => 'none']],[['text' => '📇 بازه امتیاز روزانه', 'callback_data' => 'setting_dayli'],['text' => $dayli['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 عضویت در کانال', 'callback_data' => 'setup_channels'],['text' => $allTexts[$channels['type_id']], 'callback_data' => 'none']],[['text' => '📢 جایزه عضویت در کانال', 'callback_data' => 'setting_channels'],['text' => $channels['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 کانال عضویت در کانال', 'callback_data' => 'channelseting_channels'],['text' => '📢', 'callback_data' => 'none']],[['text' => '☎️ تایید شماره', 'callback_data' => 'setup_numberConfig'],['text' => $allTexts[$numberConfig['type_id']], 'callback_data' => 'none']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, 'با موفقیت ست شد ✅', 'HTML', $set_off_btn);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '{$from_id}'");
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^setting_(.*)/', $step, $match) and $type === 'private')
    {
        $db->query("UPDATE `settings` SET `columnOne` = '$text' WHERE `type` = '{$match[1]}'");
        deleteMessage($from_id, $message_id - 1);
        file_exists('OFF') ? $power = '❌' : $power = '✅';
        $numberConfig = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'numberConfig'"));
        $refral       = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'refral'"));
        $free         = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'free'"));
        $reaction     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'reaction'"));
        $cup          = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'cup'"));
        $dayli        = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'dayli'"));
        $channels     = mysqli_fetch_assoc($db->query("SELECT * FROM `settings` WHERE `type` = 'channels'"));
        $set_off_btn  = json_encode(['inline_keyboard' => [[['text' => '⚙️ تنظیمات', 'callback_data' => 'none'],['text' => '❕وضعیت کنونی', 'callback_data' => 'none']],[['text' => '🤖 ربات', 'callback_data' => 'offonbot'],['text' => $power, 'callback_data' => 'none']],[['text' => '🏆 جام به اضای خرید', 'callback_data' => 'setup_cup'],['text' => $allTexts[$cup['type_id']], 'callback_data' => 'none']],[['text' => '🏆 جایزه جام به اضای خرید', 'callback_data' => 'setting_cupl'],['text' => $cup['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '👥 زیرمجموعه گیری', 'callback_data' => 'setup_refral'],['text' => $allTexts[$refral['type_id']], 'callback_data' => 'none']],[['text' => '👥جایزه زیرمجموعه گیری', 'callback_data' => 'setting_refral'],['text' => $refral['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '💸 موجودی اولیه', 'callback_data' => 'setup_free'],['text' => $allTexts[$free['type_id']], 'callback_data' => 'none']],[['text' => '💸 مقدار موجودی اولیه', 'callback_data' => 'setting_free'],['text' => $free['columnOne'] . ' تومان', 'callback_data' => 'none']],[['text' => '🔥 ریکشن', 'callback_data' => 'setup_reaction'],['text' => $allTexts[$reaction['type_id']], 'callback_data' => 'none']],[['text' => '🔥 جایزه ریکشن', 'callback_data' => 'setting_reaction'],['text' => $reaction['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '🔥 کانال ریکشن', 'callback_data' => 'channelseting_reaction'],['text' => '📢', 'callback_data' => 'none']],[['text' => '📇 امتیاز روزانه', 'callback_data' => 'setup_dayli'],['text' => $allTexts[$dayli['type_id']], 'callback_data' => 'none']],[['text' => '📇 بازه امتیاز روزانه', 'callback_data' => 'setting_dayli'],['text' => $dayli['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 عضویت در کانال', 'callback_data' => 'setup_channels'],['text' => $allTexts[$channels['type_id']], 'callback_data' => 'none']],[['text' => '📢 جایزه عضویت در کانال', 'callback_data' => 'setting_channels'],['text' => $channels['columnOne'] . ' کاپ', 'callback_data' => 'none']],[['text' => '📢 کانال عضویت در کانال', 'callback_data' => 'channelseting_channels'],['text' => '📢', 'callback_data' => 'none']],[['text' => '☎️ تایید شماره', 'callback_data' => 'setup_numberConfig'],['text' => $allTexts[$numberConfig['type_id']], 'callback_data' => 'none']],[['text' => '🔙 بازگشت', 'callback_data' => 'panel']]]]);
        sendMessage($from_id, 'با موفقیت ست شد ✅', 'HTML', $set_off_btn);
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '{$from_id}'");
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^answer_(.*)/', $step, $match))
    {
        if (!isset($text))
        {
            sendMessage($from_id, '❌ در این حالت تنها متن قابل ارسال میباشد برای ارسال عکس از بخش ارسال پیام اقدام کنید');
            mysqli_close($db);
            exit(false);
        }
        sendMessage($match[1], "👤 شما یک پیام از پشتیبانی دارید :\n\n$text", 'HTML');
        sendMessage($chat_id, '✅ با موفقیت ارسال شد', 'HTML');
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^crad-(.*)/', $step, $match) and $type === 'private')
    {
        $db->query("UPDATE `cards` SET `card` = '$from_id', `name` = '$message_id', `create_at` = '$time', `adder` = '$from_id' WHERE `type` = '{$match[1]}'");
        sendMessage($from_id, '✅ با موفقیت ست شد', 'HTML');
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^change_lock_(.*)/', $step, $match) and $type === 'private')
    {
        if ($text === 'جایگزینی لینک عمومی ربات در قفل ✔️')
        {
            sendMessage($from_id, '✅ با موفقیت با لینک اصلی جایگزین شد .', null, $panel, $message_id);
            $db->query("UPDATE `settings` SET `columnTwo` = '' WHERE `type` = 'lock' AND `type_id` = '{$match[1]}'");
            $db->query("UPDATE `user` SET `step` = 'change_lock_{$match[1]}' WHERE `from_id` = '$from_id'");
        }
        elseif (preg_match('/^https:\/\/t.me\/(.*)/', $text))
        {
            sendMessage($from_id, '✅ با موفقیت لینک جایگزین شد .', null, $panel, $message_id);
            $db->query("UPDATE `settings` SET `columnTwo` = '{$text}' WHERE `type` = 'lock' AND `type_id` = '{$match[1]}'");
            $db->query("UPDATE `user` SET `step` = 'change_lock_{$match[1]}' WHERE `from_id` = '$from_id'");
        } else sendMessage($from_id, "⚠️ توجه داشته باشید که باید با https://t.me/ شروع شود\nلطفا دوباره ارسال کنید", null, $btn_back, $message_id);
        mysqli_close($db);
        exit(false);
    }
    elseif (preg_match('/^reject_(.*)/', $step, $match))
    {
        if (!isset($text))
        {
            sendMessage($from_id, '❌ در این حالت تنها متن قابل ارسال میباشد برای ارسال عکس از بخش ارسال پیام اقدام کنید');
            mysqli_close($db);
            exit(false);
        }
        $exploded = explode('_', $step);
        $usr_info = mysqli_fetch_assoc(mysqli_query($db, "SELECT * FROM `user` WHERE `from_id` = '{$exploded[2]}'"));
        $key = json_encode(['inline_keyboard' => [[['text' => '❌ رد شده', 'callback_data' => 'none']]]]);
        editMessageText($chat_id, $exploded[3], "🧾 رسید فوق بررسی شد :\n👤 توسط : <code>$from_id</code>\n❗️ نتیجه : ❌ رد شده\n🔧 آیدی کاربر : <code>{$usr_info['row']}</code>", 'HTML', $key);
        sendMessage($exploded[2], "❌ کاربر گرامی رسید شما رد شد!\n\n❗️ دلیل : {$text}", 'HTML');
        sendMessage($chat_id, '✅ با موفقیت ارسال شد', 'HTML');
        $db->query("UPDATE `user` SET `step` = 'none' WHERE `from_id` = '$from_id'");
        mysqli_close($db);
        exit(false);
    }
}
/* =========================== 
نویسنده :
@SeniorMehdy
کانال :
@MahdyBots
در صورت بروز هر گونه مشکل ب پیوی نویسنده سورس مراجعه کنید

تحت هیچ شرایطی متن را حذف یا ویرایش نکنید
=========================== */
?>